#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>

using namespace std;

long long R, L;
long long zbir;

void poslazi(vector<vector<long long>>& X, const vector<long long>& A) {
    long long pocetakX = 0;
    long long pocetakY = 0;
    long long krajX = X.size() - 1;
    long long krajY = X[0].size() - 1;
    long long index = 0;

    while (index < A.size()) {
        X[pocetakX][pocetakY] = A[index++];
        X[pocetakX][krajY] = A[index++];
        X[krajX][krajY] = A[index++];
        X[krajX][pocetakY] = A[index++];

        for (long long j = pocetakX + 1; j < krajX; j++) {
            if (index >= A.size()) break;
            X[j][pocetakY] = A[index++];
        }

        for (long long j = pocetakY + 1; j < krajY; j++) {
            if (index >= A.size()) break;
            X[krajX][j] = A[index++];
        }

        for (long long j = pocetakX + 1; j < krajX; j++) {
            if (index >= A.size()) break;
            X[j][krajY] = A[index++];
        }

        for (long long j = pocetakY + 1; j < krajY; j++) {
            if (index >= A.size()) break;
            X[pocetakX][j] = A[index++];
        }

        ++pocetakX;
        ++pocetakY;
        --krajX;
        --krajY;

        if (X.size() % 2 == 1) {
            X[round(X.size() / 2)][round(X[0].size() / 2)] = A[A.size() - 1];
        }

        if (pocetakX > krajX || pocetakY > krajY) break;
    }
}

long long sracunajSumuPodmatrica(const vector<vector<long long>>& X) {
    long long SumaPodmatrica = 0;
    long long rows = X.size();
    long long cols = X[0].size();

    for (size_t i = 0; i < rows - R + 1; i++) {
        for (size_t j = 0; j < cols - L + 1; j++) {
            for (long long r = i; r < i + R; r++) {
                for (long long c = j; c < j + L; c++) {
                    SumaPodmatrica += X[r][c];
                }
            }
        }
    }
    return SumaPodmatrica;
}

int main() {
    long long rows, cols;
    cin >> rows;
    cin >> cols;
    cin >> R >> L;

    vector<long long> A;
    for (long long i = 0; i < rows * cols; ++i) {
        long long element;
        cin >> element;
        A.push_back(element);
    }

    if (R == 1 and L == 1) {
        for (long long i = 0; i < rows * cols; i++) {
            zbir += A[i];
        }
        cout << zbir << endl;
    } else {
        sort(A.begin(), A.end());

        vector<vector<long long>> X(rows, vector<long long>(cols, 0));

        poslazi(X, A);

        long long SumaPodmatrica = sracunajSumuPodmatrica(X);
        cout << SumaPodmatrica << endl;
    }

    return 0;
}